% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{assign_meta_data}
\alias{assign_meta_data}
\title{Assign meta data to columns in a SDTM table based on specification file}
\usage{
assign_meta_data(
  tbl,
  spec,
  datatype_col = "Data Type",
  var_col = "Variable",
  length_col = "Length",
  label_col = "Label"
)
}
\arguments{
\item{tbl}{a data frame containing a SDTM table}

\item{spec}{a data frame with the columns \code{"Variable"} which has a value for
each column in \code{tbl}, \code{"Data Type"} which specifies data types by column,
\code{"Length"} which specifies the character limit for each column, and \code{"Label"}
which specifies the label for each column}

\item{datatype_col}{a string, the column in \code{spec} that contains the data
types (which should include the values \code{"text"} and \code{"date"}); default is
\code{"Data Type"}}

\item{var_col}{a string, the column in \code{spec} that contains the domain
variable names}

\item{length_col}{a string, the column in \code{spec} that contains the character
count limits for each variable}

\item{label_col}{a string, the column in \code{spec} that contains the labels for
each variable}
}
\value{
a modified copy of \code{tbl} with the meta data per specification
}
\description{
Trims the length of each text and date variable to the length specified in
the spec and then assigns the attributes \code{"label"} and \code{"width"} to each
column.
}
\examples{
work_dir <- system.file("extdata", package = "sdtmval")
spec <- get_data_spec(domain = "XX",
                      dir = work_dir,
                      filename = "spec.xlsx")
after_meta_data <- assign_meta_data(sdtmval::xx_no_meta_data, spec = spec)
labels <- colnames(after_meta_data) |>
  purrr::map(~ attr(after_meta_data[[.]], "label")) |>
  unlist()
lengths <- colnames(after_meta_data) |>
  purrr::map(~ attr(after_meta_data[[.]], "width")) |>
  unlist()
data.frame(
  column = colnames(after_meta_data),
  labels = labels,
  lengths = lengths
)

}
\seealso{
\code{\link[=get_data_spec]{get_data_spec()}}, \code{\link[=get_key_vars]{get_key_vars()}}, \code{\link[=get_codelist]{get_codelist()}}
}
