% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{create_BLFL}
\alias{create_BLFL}
\title{Create a BLFL column}
\usage{
create_BLFL(
  tbl,
  sort_date,
  domain,
  grouping_vars = "USUBJID",
  RFSTDTC = "RFSTDTC",
  compare_date_method = "on or before"
)
}
\arguments{
\item{tbl}{a data frame with the variables \code{USUBJID}, \verb{[domain]ORRES},
\code{RFSTDTC}, and to column specified in the \code{sort_date} argument}

\item{sort_date}{a string, the column name by which to sort records within
each \code{USUBJID} entry before assigning the BLFL value. This is also the date
compared against \code{RFSTDTC} to determine the BLFL value. This column should
either already have a date class or be a character vector in the format
YYYY-MM-DD}

\item{domain}{a string, the SDTM domain abbreviation}

\item{grouping_vars}{a character vector of columns to group by when assigning
the BLFL, default is \code{"USUBJID"}. The order of this vector matters.}

\item{RFSTDTC}{a string, the column to use for \code{RFSTDTC}, default is
\code{"RFSTDTC"}; this columns should either have a date class or a characer class
in the YYYY-MM-DD format}

\item{compare_date_method}{a string, one of \code{c("on or before", "before")}
indicating where the baseline measurement should be evaluated on or before
the study start date or just before; default is \code{"on or before"}}
}
\value{
a modified copy of \code{tbl} with the new column \verb{[domain]BLFL}
}
\description{
Utilizes the BLFL method from the SDTM spec to create a baseline flag: Equal
to "Y" for last record with non-missing --ORRES on or before first dose date
(RFSTDTC); \code{NA} otherwise.
}
\examples{
df <- dplyr::tibble(
  USUBJID = c(
    rep(1, 3),
    rep(2, 3)
  ),
  XXORRES = c(
    1, 2, 2,
    1, 2, NA
  ),
  XXDTC = as.Date(c(
    "2017-02-05", "2017-02-06", "2017-02-07",
    "2017-02-05", "2017-02-06", "2017-02-07"
  )),
  RFSTDTC = as.Date(c(
    rep("2017-02-05", 3),
    rep("2017-02-07", 3)
  ))
)
create_BLFL(df, sort_date = "XXDTC", domain = "XX")

}
\seealso{
\code{\link[=create_EPOCH]{create_EPOCH()}}, \code{\link[=calc_DY]{calc_DY()}}
}
