% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_edc_tbls}
\alias{read_edc_tbls}
\title{Import EDC data tables}
\usage{
read_edc_tbls(edc_tbls, dir)
}
\arguments{
\item{edc_tbls}{character vector of EDC table file names (without extension)}

\item{dir}{string, EDC data directory}
}
\value{
a named list of data frames where the names are taken from \code{edc_tbls}
and the data frames are the EDC data tables
}
\description{
Reads-in EDC data table .csv files and puts them in a list.
}
\details{
The file encoding will be UTF-8.
}
\examples{
edc_tbls <- c("xx", "vd")
edc_dir <- system.file("extdata", package = "sdtmval")
edc_dat <- read_edc_tbls(edc_tbls, dir = edc_dir)

}
\seealso{
\code{\link[=read_sdtm_tbls]{read_sdtm_tbls()}}
}
