% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{reshape_pdates}
\alias{reshape_pdates}
\title{Reshape format of partial dates}
\usage{
reshape_pdates(dates, output_sep = "/")
}
\arguments{
\item{dates}{a character vector of partial dates}

\item{output_sep}{the date component separator for the output, default is
\code{"/"}}
}
\value{
a character vector of partial dates in the format \code{"UN/UN/UNKN"}
(\code{"MM/DD/YYYY"})
}
\description{
Re-arranges partial dates from a format of \code{"UN-UNK-UNKN"} (\code{"DD-MMM-YYYY"})
to \code{"UN/UN/UNKN"} (\code{"MM/DD/YYYY"}).
}
\details{
\itemize{
\item The separator character between dates components for the input vector
\code{dates} can be any commonly used date separator (\code{"/"}, \code{"-"}, \code{"."},
\code{" "}).
\item In the starting format, the month (\code{"UNK"}) is a three letter abbreviation
but, in the output format, the month is converted to a number
\item The output format is a character vector, not a Date vector, to make some
common SDTM date workflow operations easier
\item The case of the input month abbreviation does not matter; \code{"Feb"},
\code{"feb"}, and \code{"FEB"} will yield the same results
}
}
\examples{
dates <- c(
  "UN-UNK-UNKN",
  "UN/UNK/UNKN",
  "UN-UNK-2017",
  "UN-Feb-2017",
  "05-Feb-2017",
  "05-UNK-2017",
  "05-Feb-UNKN",
  NA
)
reshape_pdates(dates)

}
\seealso{
\code{\link[=reshape_adates]{reshape_adates()}}, \code{\link[=impute_pdates]{impute_pdates()}}, \code{\link[=trim_dates]{trim_dates()}},
\code{vignette("Dates")}
}
