% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{trim_and_make_blanks_NA}
\alias{trim_and_make_blanks_NA}
\title{Trim white space and make blanks NA}
\usage{
trim_and_make_blanks_NA(tbl)
}
\arguments{
\item{tbl}{a data frame, the SDTM table}
}
\value{
a modified copy of the \code{tbl} data frame
}
\description{
Trims the white space on both sides of strings in a character vector and
replaces blank values (\code{""} and \code{" "}) with \code{NA} for all columns in a data
frame that have a character class.
}
\details{
This function should be applied as one of the first steps in the data process
to ensure consistent handling of all strings.
}
\examples{
df <- data.frame(one = c("   a", "", " "))
trim_and_make_blanks_NA(df)

}
\seealso{
\code{\link[=format_chars_and_dates]{format_chars_and_dates()}}
}
