% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/season-package.R
\docType{data}
\name{stillbirth}
\alias{stillbirth}
\title{Stillbirths in Queensland, 1998--2000}
\format{
A data frame with 60,110 observations on the following 7 variables.
\describe{ \item{dob}{date of birth (year-month-day)}
\item{year}{year of birth} \item{month}{month of birth}
\item{yrmon}{a combination of year and month:
\eqn{year+(month-1)/12}} \item{seifa}{SEIFA score, an area level
measure of socioeconomic status in quintiles}
\item{gestation}{gestation in weeks}
\item{stillborn}{stillborn (yes/no); 1=Yes, 0=No} }
}
\source{
From Queensland Health.
}
\usage{
stillbirth
}
\description{
Monthly number of stillbirths in Australia from 1998 to 2000. It is a rare
event; there are 352 stillbirths out of 60,110 births.  To preserve
confidentiality the day of birth has been randomly re-ordered.
}
\examples{

data(stillbirth)
table(stillbirth$month, stillbirth$stillborn)

}
\keyword{datasets}
