% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higher_freq.R
\name{gf_freq}
\alias{gf_freq}
\title{Genotype frequencies of an F1 population under a generalized model.}
\usage{
gf_freq(
  p1_g,
  p1_ploidy,
  p1_gamma = NULL,
  p1_alpha = NULL,
  p1_beta = NULL,
  p1_type = c("mix", "polysomic"),
  p1_add_dr = TRUE,
  p2_g,
  p2_ploidy,
  p2_gamma = NULL,
  p2_alpha = NULL,
  p2_beta = NULL,
  p2_type = c("mix", "polysomic"),
  p2_add_dr = TRUE,
  pi = 0,
  nudge = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{p1_g, p1_ploidy, p1_gamma, p1_alpha, p1_beta, p1_type, p1_add_dr}{The first parent's version of the parameters in \code{\link{gamfreq}()}.}

\item{p2_g, p2_ploidy, p2_gamma, p2_alpha, p2_beta, p2_type, p2_add_dr}{The second parent's version of the parameters in \code{\link{gamfreq}()}.}

\item{pi}{The proportion of outliers.}

\item{nudge}{Zeros go to nudge}
}
\value{
A vector of genotype frequencies. Element \code{i} is the probability
and offspring has genotype \code{i - 1}.
}
\description{
Genotype frequencies of an F1 population under a generalized model.
}
\examples{
q <- gf_freq(
  p1_g = 2,
  p1_ploidy = 4,
  p1_gamma = c(0.1, 0.9),
  p1_type = "mix",
  p2_g = 2,
  p2_ploidy = 6,
  p2_alpha = 0.1,
  p2_type = "polysomic",
  pi = 0.05)

}
\seealso{
\code{\link{gamfreq}()}.
}
\author{
David Gerard
}
