% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mint.R
\name{MINTsemiperm}
\alias{MINTsemiperm}
\alias{MINTsemiauto}
\title{Mutual information independence test (categorical-continuous case)}
\usage{
MINTsemiperm(X, y, k, B = 1000)

MINTsemiauto(X, y, kmax, B1 = 1000, B2 = 1000)
}
\arguments{
\item{X}{Data of multivariate continuous variables, which should be an
\eqn{n}-by-\eqn{p} matrix, or, a vector of length \eqn{n} (for univariate
variable).}

\item{y}{Data of categorical variables, which should be a factor of length
\eqn{n}.}

\item{k}{Number of nearest neighbor. See References for details.}

\item{B, B1, B2}{Number of permutations to use. Defaults to 1000.}

\item{kmax}{Maximum \code{k} in the automatic search for optimal \code{k}.}
}
\value{
A list with class \code{"indtest"} containing the following components
\itemize{
\item \code{method}: name of the test;
\item \code{name_data}: names of the \code{X} and \code{y};
\item \code{n}: sample size of the data;
\item \code{num_perm}: number of replications in permutation test;
\item \code{stat}: test statistic;
\item \code{pvalue}: computed p-value.
}

For \code{MINTsemiauto()}, the list also contains
\itemize{
\item \code{kmax}: maximum \code{k} in the automatic search for optimal \code{k};
\item \code{kopt}: optimal \code{k} chosen.
}
}
\description{
Implement the mutual information independence test (MINT)
(Berrett and Samworth, 2019), but with some modification in estimating the
mutual informaion (MI) between a categorical random variable and a
continuous variable. The modification is based on the idea of Ross (2014).

\code{MINTsemiperm()} implements the permutation independence test via
mutual information, but the parameter \code{k} should be pre-specified.

\code{MINTsemiauto()} automatically selects an appropriate \code{k} based on a
data-driven procedure, and conducts \code{MINTsemiperm()} with the \code{k} chosen.
}
\examples{
X <- mtcars[, c("mpg", "disp", "drat", "wt")]
y <- factor(mtcars[, "am"])

MINTsemiperm(X, y, 5)
MINTsemiauto(X, y, kmax = 32)

}
\references{
\enumerate{
\item Berrett, Thomas B., and Richard J. Samworth. "Nonparametric
independence testing via mutual information." \emph{Biometrika} 106, no. 3
(2019): 547-566.
\item Ross, Brian C. "Mutual information between discrete and
continuous data sets." \emph{PloS one} 9, no. 2 (2014): e87357.
}
}
