% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_geo.R, R/semnar-package.R
\name{guess_address.semnar}
\alias{guess_address.semnar}
\alias{guess_address}
\title{Guess presentation address in a \code{\link{semnar}} object using OSM's API for reverse geocoding}
\usage{
\method{guess_address}{semnar}(object, all = FALSE)

guess_address(object, all = TRUE)
}
\arguments{
\item{object}{an object of class \code{\link{semnar}}. See \code{\link[=add_presentation]{add_presentation()}}.}

\item{all}{should we be guessing all addresses (\code{TRUE}) or only missing ones (\code{FALSE}; default)?}
}
\value{
An object of class \code{\link{semnar}} with all (\code{all = TRUE}) or the missing presentation addresses (\code{all = FALSE}) completed.
}
\description{
Guess presentation address in a \code{\link{semnar}} object using OSM's API for reverse geocoding
}
\details{
\code{\link[=guess_address]{guess_address()}} is using reverse geocoding through the API at
\url{https://nominatim.openstreetmap.org}. Please check at that
link for requests limits.
}
\examples{
\donttest{
out <- add_presentation(country = "England", city = "Coventry",
                        lon = -1.560843, lat = 52.384019,
                        event = "Young Researchers' Meeting",
                        title = "A workflow that most probably isn't yours",
                        link = "https://warwick.ac.uk/fac/sci/statistics/news/yrm/",
                        materials = "https://ikosmidis.com/files/ikosmidis_YRM_2019.pdf",
                        type = "presentation", institution = "University of Warwick",
                        department = "Department of Statistics",
                        venue = "Mathematical Sciences Building", room = "M1.02",
                        year = 2019, month = 5, day = 28,
                        start_hour = 16, start_min = 00,
                        end_hour = 17, end_min = 00) |>
        add_presentation(country = "United States", city = "Stanford",
                         lon = -122.165330, lat = 37.429464,
                         event = "useR! 2016",
                         title = "brglm: Reduced-bias inference in generalized linear models",
                         link = "https://user2016.r-project.org//files/abs-book.pdf",
                         materials = "https://bit.ly/2KCBbKg",
                         type = "presentation", institution = NA, department = NA,
                         venue = "Stanford Institute for Economic Policy Research",
                         room = "Siepr 120",
                         year = 2016, month = 06, day = 29,
                         start_hour = 14, start_min = 15,
                         end_hour = 14, end_min = 35)
out$address
# Reverse geocoding
out <- guess_address(out)
out$address
}

}
\seealso{
\code{\link{add_presentation}}
}
