% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise.R
\name{dist_matrix}
\alias{dist_matrix}
\title{Compute distances between all combinations of two sets of sequences}
\usage{
dist_matrix(
  query,
  target,
  mode,
  cost_matrix = NULL,
  gap_cost = NA_integer_,
  gap_open_cost = NA_integer_,
  nthreads = 1,
  show_progress = FALSE
)
}
\arguments{
\item{query}{A character vector of query sequences.}

\item{target}{A character vector of target sequences.}

\item{mode}{The distance metric to use. One of hamming (hm), global (gb) or anchored (an).}

\item{cost_matrix}{A custom cost matrix for use with the "global" or "anchored" distance metrics. See details.}

\item{gap_cost}{The cost of a gap for use with the "global" or "anchored" distance metrics. See details.}

\item{gap_open_cost}{The cost of a gap opening. See details.}

\item{nthreads}{The number of threads to use for parallel computation.}

\item{show_progress}{Whether to show a progress bar.}
}
\value{
The output is a distance matrix between all query (rows) and target (columns) sequences.
For anchored searches, the output also includes attributes "query_size" and "target_size" which are matrices containing the lengths of the query and target sequences that are aligned.
}
\description{
Compute distances between all combinations of query and target sequences
}
\details{
This function calculates all combinations of pairwise distances based on Hamming, Levenshtein or Anchored algorithms.
The output is a NxM matrix where N = length(query) and M = length(target).
Note: this can take a \emph{really} long time; be careful with input size.

Three types of distance metrics are supported, based on the form of alignment performed. These are: Hamming, Global (Levenshtein) and Anchored.

An anchored alignment is a form of semi-global alignment, where the query sequence is "anchored" (global) to the beginning of both the query and target sequences,
but is semi-global in that the end of the either the query sequence or target sequence (but not both) can be unaligned. This type of alignment is sometimes called an "extension" alignment in literature.

In contrast a global alignment must align the entire query and target sequences. When mismatch and indel costs are equal to 1, this is also known as the Levenshtein distance.

By default, if mode == "global" or "anchored", all mismatches and indels are given a cost of 1. However, you can define your own distance metric by setting the substitution cost_matrix and separate gap parameters.
The cost_matrix is a strictly positive square integer matrix of substitution costs and should include all characters in query and target as column- and rownames. Any rows/columns named "gap" or "gap_open" are ignored.
To set the cost of a gap (insertion or deletion), use the gap_cost parameter (a single positive integer). To enable affine gaps, provide the gap_open_cost parameter (a single positive integer) in addition to gap_cost.
If affine alignment is used, the total cost of a gap of length L is defined as:
TOTAL_GAP_COST = gap_open_cost + (gap_cost * gap_length).

If mode == "hamming" all alignment parameters are ignored; mismatch is given a distance of 1 and gaps are not allowed.
}
\examples{
dist_matrix(c("ACGT", "AAAA"), c("ACG", "ACGT"), mode = "global")
}
