% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{pitchMapping}
\alias{pitchMapping}
\title{Pitch mapping function}
\usage{
pitchMapping(x, notes)
}
\arguments{
\item{x}{Numeric vector}

\item{notes}{character vector, notes onto which values are map (i.e. the musical scakle).
Notes should be written in Scientific pitch notation, e.g. c('C4','E4','G4')
(see \url{https://en.wikipedia.org/wiki/Scientific_pitch_notation})}
}
\value{
a character vector representing the original values transformed into pitches
}
\description{
Maps a series of values into pitches of notes
}
\examples{
pitchMapping(x=1:10,notes=c('C4','E4','G4'))
pitchMapping(rnorm(20),notes=c('E3','Gb3','G3','A3','B3','C4','D4'))
}
