% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{bayes_nlg}
\alias{bayes_nlg}
\title{Bayesian method (Negative Log Gamma Prior)}
\usage{
bayes_nlg(s, n, alpha, MonteCarlo, ...)
}
\arguments{
\item{s}{Vector of successes.}

\item{n}{Vector of sample sizes.}

\item{alpha}{The significance level; to calculate a 100(1-\eqn{\alpha})\% lower confidence bound.}

\item{MonteCarlo}{Number of samples to draw from the posterior distribution for the Monte Carlo estimate.}

\item{...}{Additional arguments to be ignored.}
}
\value{
The 100(1-\eqn{\alpha})\% lower confidence bound.
}
\description{
Caclulate a binomal series lower confidence bound using Bayes' method with negative log gamma priors on the components, defined such that the prior on the system is a uniform distribution.
}
\examples{
bayes_nlg(s=c(35, 97, 59), n=c(35, 100, 60), alpha=.10, MonteCarlo=1000)
}
