% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_tracker.R
\name{sst_rt_competitors}
\alias{sst_rt_competitors}
\title{Get the data on competitors in search results}
\usage{
sst_rt_competitors(
  project_id,
  region_id,
  date_from = Sys.Date() - 8,
  date_to = Sys.Date() - 1,
  domains = NULL,
  sort = "sum_traffic",
  sort_range = "top1",
  order = "desc",
  page = 1,
  size = 100,
  return_method = "list",
  api_token = Sys.getenv("SERPSTAT_API_TOKEN")
)
}
\arguments{
\item{project_id}{(required) The ID of your project in Serpstat. You can
find this ID in the URL of any rank tracker report. As an example, in
https://serpstat.com/rank-tracker/keywords/12345/positions?get_params the
ID would be 12345.}

\item{region_id}{(required) The ID of a region returned by
\code{\link{sst_rt_project_regions}}.}

\item{date_from}{(optional) The date string in 'YYYY-MM-DD' format to
specify the initial date of retrieved data. Default value is current date
minus 8 days.}

\item{date_to}{(optional) The date string in 'YYYY-MM-DD' format to
specify the final date of retrieved data. Must not exceed date_from + 30
days.  Default value is yesterday.}

\item{domains}{(optional) A vector of domain names for which the data
should be retrieved. By default the data is retrieved for all domains
that rank for at least two keywords that are added to the project.}

\item{sort}{(optional) Must be one of 'sum_traffic' (default, domain search
traffic distribution), 'keywords_count' (number of keywords),
'avg_position' (average domain position), 'position_ranges' (ranges of
positions), 'ads_count' (number of ads in search engine results).}

\item{sort_range}{(optional) The subcategory of ranges of positions to sort
by. Must be one of 'top1', 'top3', 'top5', 'top10', 'top20', 'top101' to
sort by the number of keywords in specific positions range; or
'keywords_count_top', 'keywords_count_bottom' to sort by the number of
keywords in  search ads blocks; or 'avg_position_top',
'avg_position_bottom' to sort by the average position in search ads blocks.}

\item{order}{(optional) The sorting order. Must be one of string 'desc'
(default) for descending sorting or 'asc' for ascending sorting.}

\item{page}{(optional) Response page number if there are many pages in response. The
default value is 1.}

\item{size}{(optional) Response page size. Must be one of 20, 50, 100, 200, 500.The
default value is 100.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}

\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}. Default is Sys.getenv('SERPSTAT_API_TOKEN').}
}
\value{
Returns traffic and keywords distributions, average positions of
  the domains by date.
}
\description{
This method method returns the competing in top20 search results domains
  that rank for at least two keywords that are added the project.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://api-docs.serpstat.com/docs/serpstat-public-api/wm6nv6iuemkrv-get-top-competitors-domains-history}{here}.
}

\section{API credits consumption}{
 0
}

\examples{
\dontrun{
project_id <- 12345
region_id  <- sst_rt_competitors(
  project_id = project_id
  )$data$regions[[1]]$id
sst_rt_competitors(
  api_token     = api_token,
  project_id    = project_id,
  region_id     = region_id,
  date_from     = '2020-12-01',
  date_to       = '2020-12-30',
  domains       = c('serpstat.com', 'serpstatbot.com'),
  sort          = 'sum_traffic',
  sort_range    = 'top1',
  order         = 'desc',
  page          = 1,
  size          = 20,
  return_method = 'list'
)
}
}
