% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_analytics.R
\name{sst_sa_keyword_top}
\alias{sst_sa_keyword_top}
\title{Top for a keyword}
\usage{
sst_sa_keyword_top(
  keyword,
  se,
  sort = NULL,
  size = 100,
  api_token = Sys.getenv("SERPSTAT_API_TOKEN")
)
}
\arguments{
\item{keyword}{(required) A keyword to search for.}

\item{se}{(required) Search engine alias (db_name) returned by
\code{\link{sst_sa_database_info}}.}

\item{sort}{(optional) A field to sort the response. See API docs for more details.}

\item{size}{(optional) Response page size. Should be => 10 and <=100. Default is 100.}

\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}. Default is Sys.getenv('SERPSTAT_API_TOKEN').}
}
\value{
Returns a list with the data about search engine results page for the keyword.
}
\description{
Returns a list of results (URLs) from search engine results page (SERP) including
organic results, paid results and different types of SERP features.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://api-docs.serpstat.com/docs/serpstat-public-api/env4osjb1ev9c-get-keyword-top}{here}.
}

\section{API credits consumption}{
 1 per URL in response.
}

\examples{
\dontrun{
sst_sa_keyword_top(
  keyword   = 'serpstat',
  se        = 'g_us',
  size  = 10
)
}
}
