% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rupture.R
\name{rupture}
\alias{rupture}
\title{Rupture}
\usage{
rupture(
  html = rupture_default(),
  color = "#fff",
  opacity = 1,
  bg_color = "#333e48",
  bg_image = NULL,
  ms = 1000 * 60 * 15,
  session = shiny::getDefaultReactiveDomain(),
  box = FALSE
)
}
\arguments{
\item{html}{Shiny tags to use as content for the disconnected screen,
generally \code{\link[shiny:reexports]{shiny::tagList()}}.}

\item{opacity}{Opacity of background.}

\item{bg_color, color}{Background color, color of text.}

\item{bg_image}{Background image to use.}

\item{ms}{Milliseconds before showing the disconnected screen,
defaults to \code{1000 * 60 * 15} which is 15 minutes (same as shinyapps.io).}

\item{session}{A valid shiny session.}

\item{box}{Set to \code{TRUE} to enclose the \code{html} in a box.}
}
\value{
None
}
\description{
Displays a disconnected screen after \code{ms} milliseconds of inactivity.
}
\examples{
library(shiny)

ui <- fluidPage(
 useSever(),
 h1("rupture")
)

server <- function(input, output){
 rupture(
   tagList(
     h1("Whoops"),
     reconnect_button()
   )
 )
}

if(interactive())
 shinyApp(ui, server)

}
