% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{st_central_point}
\alias{st_central_point}
\alias{st_central_point.sfg}
\alias{st_central_point.sf}
\alias{st_central_point.sfc}
\title{Spatial centrality}
\usage{
st_central_point(.x, .y, ...)

\method{st_central_point}{sfg}(
  .x,
  .y = NULL,
  weights = NULL,
  method = c("mean", "median", "geometric", "feature", "min.dist"),
  ...
)

\method{st_central_point}{sf}(
  .x,
  .y = NULL,
  weights = NULL,
  method = c("mean", "median", "geometric", "feature", "min.dist"),
  ...
)

\method{st_central_point}{sfc}(
  .x,
  .y = NULL,
  weights = NULL,
  method = c("mean", "median", "geometric", "feature", "min.dist"),
  ...
)
}
\arguments{
\item{.x, .y}{\code{sf} points 2D or 3D}

\item{...}{arguments to be passed to or from other methods}

\item{weights}{Numeric. Used in for weighted Mean Center. Has to be same length
as number of points.}

\item{method}{Character. Type of center point to calculate}

\item{dist}{Atomic numeric, Default 100. Starting distance value for center
moving during iterations.}
}
\value{
\code{"Simple Features"} of length 1.
}
\description{
Functions to find spatial measures of gravity centers.
}
\details{
Spatial centers are spatial measures of the gravity center.

\code{methods} options are:
\code{"mean"} is the mean center (equivalent to centroid of the points) calculated by
the arithmetic mean of each axis;
\code{"geometric"}, is the corresponding geometric mean of each axis;
\code{"median"}, is the median center, a pair of c(median(x), median(y)) coordinates;
\code{"feature"}, is a minimization of the sum of distances from \emph{ith} point to every point;
\code{"min.dist"}, is iterative looking for the closest point in bbox of .x
that minimizes the sum of distances from \emph{ith} point to every point in the dataset
}
\note{
Inspired on \verb{aspace::*()} from Ron Buliung & Randy Bui (2012)
}
\examples{
requireNamespace("ggplot2", quietly = TRUE)
library(sf, quietly = TRUE)
library(ggplot2)
bbx <- matrix(c(697047,9553483,
                696158,9560476,
                700964,9561425,
                701745,9555358),
              byrow = TRUE,
              ncol = 2)
bbx <- st_multipoint(bbx)
bbx <- st_cast(bbx,"POLYGON")
bbx <- st_sfc(bbx, crs = 31992)
set.seed(1234)
points <- st_sf(geometry = st_sample(bbx, 100))
mean_center <- st_central_point(points, method = "mean")
median_center <- st_central_point(points, method = "median")
geom_center <- st_central_point(points, method = "geometric")
central_feature <- st_central_point(points, method = "feature")
min_dist_center <- st_central_point(points, method = "min.dist")
ggplot() +
  geom_sf(data = points, color = "steelblue", size = 0.5) +
  geom_sf(data = mean_center, color = "blue", size = 3) +
  geom_sf(data = median_center, color = "red") +
  geom_sf(data = geom_center, color = "grey80") +
  geom_sf(data = central_feature, color = "orange") +
  geom_sf(data = min_dist_center, color = "green")
}
\author{
Gabriel Gaona
}
