% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_reduce.R
\name{sfc_reduce,sfc_nxn-method}
\alias{sfc_reduce,sfc_nxn-method}
\alias{sfc_reduce}
\alias{sfc_reduce,matrix-method}
\alias{add_base_structure}
\title{Reduce a curve}
\usage{
\S4method{sfc_reduce}{sfc_nxn}(p, to = sfc_level(p) - 1)

\S4method{sfc_reduce}{matrix}(p, to = level - 1, mode = NULL)

add_base_structure(gb, level = 1)
}
\arguments{
\item{p}{An \code{sfc_nxn} object.}

\item{to}{Which level to reduce to? Value should be between 1 and \code{sfc_level(p) - 1}.}

\item{mode}{Mode of the curve.}

\item{gb}{A \code{grob} object returned by \code{\link[=sfc_grob]{sfc_grob()}} or a \code{sfc_nxn} object then \code{\link[=sfc_grob]{sfc_grob()}} is internally applied.}

\item{level}{The level of the unit.}
}
\value{
A two-column matrix of coordinates of the reduced curve.
}
\description{
Reduce a curve
}
\details{
The reduction is applied on the coordinates of points.

\code{add_base_structure()} adds a base structure on a certain level to the curve.
}
\examples{
p = sfc_3x3_peano("I", level = 3)
draw_multiple_curves(
    p, 
    sfc_reduce(p, 2), 
    sfc_reduce(p, 1), 
    nrow = 1)
p = hilbert_curve(level = 4)
draw_multiple_curves(
    p, 
    sfc_reduce(p, 3), 
    sfc_reduce(p, 2), 
    nrow = 1)
p = hilbert_curve(3)
draw_multiple_curves(
    add_base_structure(p, level = 1),
    add_base_structure(p, level = 2),
    nrow = 1
)
}
