% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgdGMF-package.R
\docType{package}
\name{sgdGMF-package}
\alias{sgdGMF}
\alias{sgdGMF-package}
\title{sgdGMF: Estimation of Generalized Matrix Factorization Models via Stochastic Gradient Descent}
\description{
Efficient framework to estimate high-dimensional generalized matrix factorization models using penalized maximum likelihood under a dispersion exponential family specification. Either deterministic and stochastic methods are implemented for the numerical maximization. In particular, the package implements the stochastic gradient descent algorithm with a block-wise mini-batch strategy to speed up the computations and an efficient adaptive learning rate schedule to stabilize the convergence. All the theoretical details can be found in Castiglione et al. (2024, \doi{10.48550/arXiv.2412.20509}). Other methods considered for the optimization are the alternated iterative re-weighted least squares and the quasi-Newton method with diagonal approximation of the Fisher information matrix discussed in Kidzinski et al. (2022, \url{http://jmlr.org/papers/v23/20-1104.html}).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/CristianCastiglione/sgdGMF}
  \item Report bugs at \url{https://github.com/CristianCastiglione/sgdGMF/issues}
}

}
\author{
\strong{Maintainer}: Cristian Castiglione \email{cristian_castiglione@libero.it} (\href{https://orcid.org/0000-0001-5883-4890}{ORCID})

Other contributors:
\itemize{
  \item Davide Risso \email{davide.risso@unipd.it} (\href{https://orcid.org/0000-0001-8508-5012}{ORCID}) [contributor]
  \item Alexandre Segers \email{alexandre.segers@ugent.be} (\href{https://orcid.org/0009-0004-2028-7595}{ORCID}) [contributor]
}

}
\keyword{internal}
