% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsample.R
\name{subsample}
\alias{subsample}
\title{subsample}
\usage{
subsample(sampleDist, sampleSize, withReplacement, clusterIDs, clusterID)
}
\arguments{
\item{sampleDist}{A vector whose length is equal to the number of clusters
that indicates the probability of sampling each cluster}

\item{sampleSize}{A scalar value indicating how larger of a subsample is
being drawn}

\item{withReplacement}{A logical value indicating whether the
subsampling is beign done with or without replacement}

\item{clusterIDs}{A vector of all of the UNIQUE cluster IDs}

\item{clusterID}{A vector of length equal to the number of observations
indicating which cluster each observation is in}
}
\value{
A list with two variables: \code{subSampleIndicator}, which
indicates which observations are in the current subsample, and
\code{clusterIDCurr}, which indicates the clusterID for the subsample.
}
\description{
Internal function to execute the subsampling component of
the stochastic stagewise approach. If a user provides a \code{stochastic}
value between 0 and 1, it is assumed that some proportion of subsampling
is desired. The \code{samplingDistCalculation} function calculates the
distribution of the clusters and the \code{subsample} function uses that
distribution to draw the actual subsample.
}
\note{
Internal function.

While most of the subsample can be determined from the
\code{subSampleIndicator}, the \code{clusterIDCurr} value has to be
constructed inside the \code{subsample function} as the way the cluster
IDs is handled is different depending o n whether we are sampling with
or without replacement.
}
\author{
Gregory Vaughan
}
\keyword{internal}
