% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct_pattern_marks.R
\name{reconstruct_pattern_marks}
\alias{reconstruct_pattern_marks}
\title{reconstruct_pattern_marks}
\usage{
reconstruct_pattern_marks(
  pattern,
  marked_pattern,
  n_random = 1,
  e_threshold = 0.01,
  max_runs = 10000,
  no_change = Inf,
  annealing = 0.01,
  r_length = 250,
  r_max = NULL,
  return_input = TRUE,
  simplify = FALSE,
  verbose = TRUE,
  plot = FALSE
)
}
\arguments{
\item{pattern}{ppp object with pattern.}

\item{marked_pattern}{ppp  object with marked pattern. See Details section for more information.}

\item{n_random}{Integer with number of randomizations.}

\item{e_threshold}{Double with minimum energy to stop reconstruction.}

\item{max_runs}{Integer with maximum number of iterations if \code{e_threshold}
is not reached.}

\item{no_change}{Integer with number of iterations at which the reconstruction will
stop if the energy does not decrease.}

\item{annealing}{Double with probability to keep relocated point even if energy
did not decrease.}

\item{r_length}{Integer with number of intervals from \code{r = 0} to \code{r = rmax} for which
the summary functions are evaluated.}

\item{r_max}{Double with maximum distance used during calculation of summary functions. If \code{NULL},
will be estimated from data.}

\item{return_input}{Logical if the original input data is returned.}

\item{simplify}{Logical if only pattern will be returned if \code{n_random = 1}
and \code{return_input = FALSE}.}

\item{verbose}{Logical if progress report is printed.}

\item{plot}{Logical if pcf(r) function is plotted and updated during optimization.}
}
\value{
rd_mar
}
\description{
Pattern reconstruction of marked pattern
}
\details{
The function randomizes the numeric marks of a point pattern using pattern reconstruction
as described in Tscheschel & Stoyan (2006) and Wiegand & Moloney (2014). Therefore,
an unmarked as well as a marked pattern must be provided. The unmarked pattern must have
the spatial characteristics and the same observation window and number of points
as the marked one (see \code{reconstruct_pattern_*} or \code{\link{fit_point_process}}).
Marks must be numeric because the mark-correlation function is used as summary function.
Two randomly chosen marks are switch each iterations and changes only kept if the
deviation between the observed and the reconstructed pattern decreases.

\code{spatstat} sets \code{r_length} to 513 by default. However, a lower value decreases
the computational time while increasing the "bumpiness" of the summary function.
}
\examples{
\dontrun{
pattern_recon <- reconstruct_pattern(species_a, n_random = 1, max_runs = 1000,
simplify = TRUE, return_input = FALSE)
marks_sub <- spatstat.geom::subset.ppp(species_a, select = dbh)
marks_recon <- reconstruct_pattern_marks(pattern_recon, marks_sub,
n_random = 19, max_runs = 1000)
}

}
\references{
Kirkpatrick, S., Gelatt, C.D.Jr., Vecchi, M.P., 1983. Optimization by simulated
annealing. Science 220, 671–680. <https://doi.org/10.1126/science.220.4598.671>

Tscheschel, A., Stoyan, D., 2006. Statistical reconstruction of random point
patterns. Computational Statistics and Data Analysis 51, 859–871.
<https://doi.org/10.1016/j.csda.2005.09.007>

Wiegand, T., Moloney, K.A., 2014. Handbook of spatial point-pattern analysis in
ecology. Chapman and Hall/CRC Press, Boca Raton. ISBN 978-1-4200-8254-8
}
\seealso{
\code{\link{fit_point_process}},
\code{\link{reconstruct_pattern}}
}
