% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilTaxonomyDendrogram.R
\name{SoilTaxonomyDendrogram}
\alias{SoilTaxonomyDendrogram}
\title{Soil Taxonomy Dendrogram}
\usage{
SoilTaxonomyDendrogram(
  spc,
  KST.order = TRUE,
  rotationOrder = NULL,
  level = c(soilorder = "soilorder", suborder = "suborder", greatgroup = "greatgroup",
    subgroup = "subgroup"),
  cluster.method = c("divisive", "agglomerative"),
  cluster.args = list(),
  name = "hzname",
  name.style = "center-center",
  id.style = "side",
  n.depth.ticks = 6,
  scaling.factor = 0.015,
  cex.names = 0.75,
  cex.id = 0.75,
  width = 0.25,
  y.offset = 0.5,
  shrink = FALSE,
  font.id = 2,
  cex.taxon.labels = 0.66,
  font.taxon.labels = 3,
  dend.color = par("fg"),
  dend.width = 1,
  dend.type = c("phylogram", "cladogram"),
  max.depth = ifelse(is.infinite(max(spc)), 200, max(spc)),
  ...
)
}
\arguments{
\item{spc}{a \code{SoilProfileCollection} object, typically returned by \code{soilDB::fetchOSD}}

\item{KST.order}{logical, encode / cluster taxa via ordinal factors, based on ordering within Keys to Soil Taxonomy}

\item{rotationOrder}{character vector of profile IDs with desired ordering of leaves in the dendrogram from left to right; exact ordering is not always possible}

\item{level}{character. One or more site-level columns in \code{spc}. Default: \code{"soilorder"}, \code{"suborder"}, \code{"greatgroup"} and \code{"subgroup"}}

\item{cluster.method}{Either "divisive" (\code{cluster::diana()}; default) or "agglomerative" (\code{cluster::agnes()})}

\item{cluster.args}{Optional: additional arguments for \code{cluster::diana()} or \code{cluster::agnes()} cluster methods}

\item{name}{column name containing horizon names}

\item{name.style}{passed to \code{aqp::plotSPC}}

\item{id.style}{passed to \code{aqp::plotSPC}}

\item{n.depth.ticks}{suggested number of ticks on the depth axis}

\item{scaling.factor}{scaling factor used to convert depth units into plotting units}

\item{cex.names}{character scaling for horizon names}

\item{cex.id}{character scaling for profile IDs}

\item{width}{width of profiles}

\item{y.offset}{vertical offset between dendrogram and profiles}

\item{shrink}{logical, should long horizon names be shrunk by 80\% ?}

\item{font.id}{integer, font style applied to profile id, default is 2 (bold)}

\item{cex.taxon.labels}{numeric, character scaling for taxonomic information}

\item{font.taxon.labels}{integer, font style applied to taxa labels, default is 3 (italic)}

\item{dend.color}{dendrogram line color}

\item{dend.width}{dendrogram line width}

\item{dend.type}{dendrogram type, passed to \code{plot.phylo()}, either "phylogram" or "cladogram"}

\item{max.depth}{depth at which profiles are truncated for plotting}

\item{...}{additional arguments to \code{aqp::plotSPC}}
}
\value{
An invisibly-returned list containing:
\itemize{
\item \code{dist}: pair-wise dissimilarity matrix
\item \code{order}: final ordering of \code{hclust} leaves
}
}
\description{
Plot a dendrogram based on the first 4 levels of Soil Taxonomy, with soil profiles hanging below. A dissimilarity matrix is computed using Gower's distance metric for nominal (\code{KST.order = FALSE}) or ordinal (\code{KST.order = TRUE}) scale variables, based on soil order, suborder, greatgroup, and subgroup taxa.
}
\details{
This function looks for specific site-level attributes named: \code{"soilorder"}, \code{"suborder"}, \code{"greatgroup"}, and \code{"subgroup"}, or their NASIS physical column name analogues \code{"taxorder"}, \code{"taxsuborder"}, \code{"taxgrtgroup"}, and \code{"taxsubgrp"}. See \url{https://github.com/ncss-tech/sharpshootR/blob/master/misc/soilTaxonomyDendrogram-examples.R} for some examples.

The \code{rotationOrder} argument uses \code{ape::rotateConstr()} to reorder leaves within the \code{hclust} representation of the ST hierarchy. Perfect sorting is not always possible.
}
\author{
D.E. Beaudette
}
