% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R, R/setters.R
\name{sh_year}
\alias{sh_year}
\alias{sh_year.jdate}
\alias{sh_year.jdatetime}
\alias{sh_year<-}
\alias{sh_year<-.jdate}
\alias{sh_year<-.jdatetime}
\title{Get/set the year component of Jalali date-time objects}
\usage{
sh_year(x)

\method{sh_year}{jdate}(x)

\method{sh_year}{jdatetime}(x)

sh_year(x) <- value

\method{sh_year}{jdate}(x) <- value

\method{sh_year}{jdatetime}(x) <- value
}
\arguments{
\item{x}{A vector of \code{jdate} or \code{jdatetime} objects.}

\item{value}{A numeric vector.}
}
\value{
The year component of x as an integer.
}
\description{
Get/set the year component of Jalali date-time objects
}
\details{
For assignment, \code{x} and \code{value} are recycled to their common size using
\link[vctrs:theory-faq-recycling]{tidyverse recycling rules}.
}
\examples{
x <- jdate("1402-12-14")
sh_year(x)
sh_year(x) <- 1400:1401
}
