% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{ScrollablePane}
\alias{ScrollablePane}
\alias{Sticky}
\title{ScrollablePane}
\usage{
ScrollablePane(...)

Sticky(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
A scrollable pane (\code{ScrollablePane}) is a helper component that's used with the \code{Sticky} component. It will "stick" to the top or bottom of the scrollable region and remain visible.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/ScrollablePane}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item \bold{ className } \code{string} \cr Additional css class to apply to the ScrollablePane
\item \bold{ componentRef } \verb{IRefObject<IScrollablePane>} \cr Optional callback to access the IScrollablePane interface. Use this instead of ref for accessing the public methods and properties of the component.
\item \bold{ initialScrollPosition } \code{number} \cr Sets the initial scroll position of the ScrollablePane
\item \bold{ scrollbarVisibility } \code{ScrollbarVisibility} \cr
\item \bold{ styles } \verb{IStyleFunctionOrObject<IScrollablePaneStyleProps, IScrollablePaneStyles>} \cr Call to provide customized styling that will layer on top of the variant rules
\item \bold{ theme } \code{ITheme} \cr Theme provided by HOC.
}
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item Use the sticky component on block-level elements.
\item Sticky components should ideally be section headers and/or footers.
\item Use \code{position: absolute}. Ensure that the parent element has an explicit \code{height} and \code{position: relative}, or has space already allocated for the scrollable pane.
\item Ensure that the total height of \code{Sticky} components does not exceed the height of the \code{ScrollablePane}.
}
}
}

\examples{
library(shiny)
library(shiny.fluent)

pane <- function(header, paragraphs) (
  div(
    Sticky(
      div(
        style = "background-color: #80CAF1; border-top: 1px solid; border-bottom: 1px solid",
        header
      )
    ),
    stringi::stri_rand_lipsum(paragraphs)
  )
)

ui <- function(id) {
  ns <- NS(id)
  ScrollablePane(
    styles = list(
      root = list(position = "relative", height = "500px", width = "400px")
    ),
    pane("Some text", 3),
    pane("A lot of text", 5),
    pane("Just a short ending", 1)
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {})
}

if (interactive()) {
  shinyApp(ui("app"), function(input, output) server("app"))
}
}
