% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R,
%   R/inputs.R
\name{SearchBox}
\alias{SearchBox}
\alias{SearchBox.shinyInput}
\alias{updateSearchBox.shinyInput}
\title{SearchBox}
\usage{
SearchBox(...)

SearchBox.shinyInput(inputId, ..., value = defaultValue)

updateSearchBox.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
The update functions return nothing (called for side effects).
}
\description{
A search box (\code{SearchBox}) provides an input field for searching content within a site or app to find specific items.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/SearchBox}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item \bold{ ariaLabel } \code{string} \cr The aria label of the SearchBox for the benefit of screen readers.
\item \bold{ className } \code{string} \cr CSS class to apply to the SearchBox.
\item \bold{ clearButtonProps } \code{IButtonProps} \cr The props for the clear button.
\item \bold{ componentRef } \verb{IRefObject<ISearchBox>} \cr Optional callback to access the ISearchBox interface. Use this instead of ref for accessing the public methods and properties of the component.
\item \bold{ defaultValue } \code{string} \cr The default value of the text in the SearchBox, in the case of an uncontrolled component. This prop is being deprecated since so far, uncontrolled behavior has not been implemented.
\item \bold{ disableAnimation } \code{boolean} \cr Whether or not to animate the SearchBox icon on focus.
\item \bold{ iconProps } \verb{Pick<IIconProps, Exclude<keyof IIconProps, 'className'>>} \cr The props for the icon.
\item \bold{ labelText } \code{string} \cr Deprecated. Use \code{placeholder} instead.
\item \bold{ onChange } \verb{(event?: React.ChangeEvent<HTMLInputElement>, newValue?: string) => void} \cr Callback function for when the typed input for the SearchBox has changed.
\item \bold{ onChanged } \verb{(newValue: any) => void} \cr Deprecated at v0.52.2, use \code{onChange} instead.
\item \bold{ onClear } \verb{(ev?: any) => void} \cr Callback executed when the user clears the search box by either clicking 'X' or hitting escape.
\item \bold{ onEscape } \verb{(ev?: any) => void} \cr Callback executed when the user presses escape in the search box.
\item \bold{ onSearch } \verb{(newValue: any) => void} \cr Callback executed when the user presses enter in the search box.
\item \bold{ placeholder } \code{string} \cr Placeholder for the search box.
\item \bold{ styles } \verb{IStyleFunctionOrObject<ISearchBoxStyleProps, ISearchBoxStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.
\item \bold{ theme } \code{ITheme} \cr Theme (provided through customization).
\item \bold{ underlined } \code{boolean} \cr Whether or not the SearchBox is underlined.
\item \bold{ value } \code{string} \cr The value of the text in the SearchBox.
}
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item Don't build a custom search control based on the default text box or any other control.
\item Use a search box without a parent container when it's not restricted to a certain width to accommodate other content. This search box will span the entire width of the space it's in.
}
}

\subsection{Content}{
\itemize{
\item Use placeholder text in the search box to describe what people can search for. For example, "Search", "Search files", or "Search contacts list".
\item Although search entry points tend to be similarly visualized, they can provide access to results that range from broad to narrow. By effectively communicating the scope of a search, you can ensure that people's expectations are met by the capabilities of the search you're performing, which will reduce the possibility of frustration. The search entry point should be placed near the content being searched.\if{html}{\out{<br/>}}\if{html}{\out{<br/>}}Some common search scopes include:
\itemize{
\item \strong{Global}: Search across multiple sources of cloud and local content. Varied results include URLs, documents, media, actions, apps, and more.
\item \strong{Web}: Search a web index. Results include pages, entities, and answers.
\item \strong{My stuff}: Search across devices, cloud, social graphs, and more. Results are varied but are constrained by the connection to user accounts.
}
}
}
}

\examples{
library(shiny)
library(shiny.fluent)

ui <- function(id) {
  ns <- NS(id)
  div(
    SearchBox.shinyInput(ns("search"), placeholder = "Search"),
    textOutput(ns("searchValue"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$searchValue <- renderText({
      sprintf("Value: \%s", input$search)
    })
  })
}

if (interactive()) {
  shinyApp(ui("app"), function(input, output) server("app"))
}
}
