% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_daisyui.R
\name{use_daisyui}
\alias{use_daisyui}
\title{Allows you to use 'daisyUI' elements}
\usage{
use_daisyui(version = "2.17.0", ...)
}
\arguments{
\item{version}{the version of 'daisyUI' to use, default is 2.17.0}

\item{...}{additional arguments passed to \code{\link[=use_tailwind]{use_tailwind()}}}
}
\value{
the required HTML-head tags to use 'daisyUI' as \code{shiny.tag}
}
\description{
See also: \url{https://daisyui.com/} and \url{https://daisyui.com/components/}
}
\details{
Note that this uses the CDN version, which is not recommended for production
by 'daisyUI'.
}
\examples{
library(shiny)

ui <- div(
  class = "h-full w-full",
  use_daisyui(),
  div(
    class = "text-sm breadcrumbs",
    tags$ul(
      tags$li(tags$a("Home")),
      tags$li(tags$a("Documents")),
      tags$li(tags$a("Add Documents"))
    )
  )
)
if (interactive()) shiny::shinyApp(ui, function(input, output) {})
}
