#' resetTimer
#'
#' Simulates a button press for `Reset`.
#'
#' @param inputId character: input slot
#'
#' @return nothing
#' @importFrom shinyjs runjs
#' @export
#'
#' @examples
#' # Example requires the use of a `shiny` app (See Vignette)
#' if (interactive()) {
#'   library(shiny)
#'   library(shinyDTC)
#'   library(shinyjs)
#'
#'   ui <- fluidPage(
#'     useShinyjs(),
#'     timerUI("timer1"),
#'     actionButton("reset", "Trigger Reset")
#'   )
#'
#'   server <- function(input, output, session) {
#'     timerServer("timer1")
#'
#'     observeEvent(input$reset, {
#'       resetTimer("timer1")
#'     })
#'   }
#'
#'   shinyApp(ui, server)
#' }
#'
#' \dontrun{
#' # `resetTimer` must be used inside a `shiny` server function
#' # and requires `shinyjs` + a corresponding timer UI
#' }
resetTimer <- function(inputId) {
  runjs(sprintf("$('#%s').click();", paste0(inputId, '_reset')))
}
