% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditionalJS.R
\name{custom-callbacks}
\alias{custom-callbacks}
\alias{runAnimation}
\title{Helpful methods for custom callback setup}
\usage{
runAnimation(..., ignoreInit = TRUE)
}
\arguments{
\item{...}{Animation object(s) created with \link{animation}; if multiple
animation objects are given then the animations will be chained.}

\item{ignoreInit}{Should the animation be skipped when application is in initial state?}
}
\description{
Can be used as a `true` or `false` argument for custom method of \link{js_calls}.
}
\examples{
library(shiny)
library(shinyGizmo)
ui <- fluidPage(
    actionButton("value", "Click me", class = "btn-primary"),
    br(), br(),
    conditionalJS(
        tags$h1("Hello", style = "display: none;"),
        "input.value \% 2 === 1",
        jsCalls$custom(
            true = runAnimation(animation("jello"), animation("swing")),
            false = runAnimation(animation("slideOutRight"))
        )
    )
)
server <- function(input, output, session) {}
if(interactive()) {
  shinyApp(ui, server)
}

}
