% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lottie_destroy.R
\name{lottie_destroy}
\alias{lottie_destroy}
\title{Destroy a 'Lottie' Animation}
\usage{
lottie_destroy(name = "all", session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{name}{A character string specifying the name of the 'Lottie' animation to destroy.
The default of "\code{all}" will destroy all animations within the 'shiny' application.}

\item{session}{The 'shiny' session object. Defaults to the current reactive domain.}
}
\value{
This function is called for a side effect, and so there is no return value.
}
\description{
Permanently destroy a specific 'Lottie' animation or all 'Lottie' animations.
}
\details{
Sends a custom session message \code{"lottie_js_destroy"} containing the function arguments.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(shinyLottie)

ui <- fluidPage(
  include_lottie(),
  lottie_animation(
    path = "shinyLottie/example.json",
    name = "my_animation"
  ),
  actionButton("destroy", "Destroy Animation")
)

server <- function(input, output, session) {
  observeEvent(input$destroy, {
    lottie_destroy("my_animation")
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{lottie_animation_methods}} for similar methods.
}
