% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/doc.R
\name{image}
\alias{image}
\title{image}
\usage{
image(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI image component.
}
\description{
The Image component is used to display images with support for fallback.
}
\details{
\itemize{
\item \bold{src}. Type: \code{string}. Default: \code{NA}.
\item \bold{srcSet}. Type: \code{string}. Default: \code{NA}.
\item \bold{sizes}. Type: \code{string}. Default: \code{NA}.
\item \bold{alt}. Type: \code{string}. Default: \code{NA}.
\item \bold{width}. Type: \code{number}. Default: \code{NA}.
\item \bold{height}. Type: \code{number}. Default: \code{NA}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{"xl"}.
\item \bold{shadow}. Type: \code{none OR sm OR md OR lg}. Default: \code{"none"}.
\item \bold{loading}. Type: \code{eager OR lazy}. Default: \code{NA}.
\item \bold{fallbackSrc}. Type: \code{string}. Default: \code{NA}.
\item \bold{isBlurred}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isZoomed}. Type: \code{boolean}. Default: \code{false}.
\item \bold{removeWrapper}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableSkeleton}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<"img" OR "wrapper" OR "zoomedWrapper" OR "blurredImg", string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onLoad}. Type: \code{ReactEventHandler<HTMLImageElement>}. Default: \code{NA}.
\item \bold{onError}. Type: \code{() => void}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  div(
    class = "flex gap-5 my-2",
    image(
      width = 300,
      alt = "NextUI hero Image",
      src = "https://heroui.com/images/hero-card-complete.jpeg"
    ),
    image(
      isBlurred = TRUE,
      width = 300,
      alt = "Album cover",
      src = "https://heroui.com/images/hero-card-complete.jpeg"
    ),
    image(
      isZoomed = TRUE,
      width = 300,
      alt = "Fruit image with zoom effect",
      src = "https://heroui.com/images/hero-card-complete.jpeg"
    )
  )
)

server <- function(input, output, session) {
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/image}.
}
