% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/inputs.R
\name{pagination}
\alias{pagination}
\alias{update_pagination}
\title{pagination}
\usage{
pagination(inputId, ..., value = default_value)

update_pagination(session = shiny::getDefaultReactiveDomain(), inputId, ...)
}
\arguments{
\item{inputId}{ID of the component.}

\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI pagination component.
}
\description{
The Pagination component allows you to display active page and navigate between multiple pages.
}
\details{
\itemize{
\item \bold{variant}. Type: \code{flat OR bordered OR light OR faded}. Default: \code{"flat"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"default"}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{"xl"}.
\item \bold{total}. Type: \code{number}. Default: \code{"1"}.
\item \bold{dotsJump}. Type: \code{number}. Default: \code{"5"}.
\item \bold{initialPage}. Type: \code{number}. Default: \code{"1"}.
\item \bold{page}. Type: \code{number}. Default: \code{NA}.
\item \bold{siblings}. Type: \code{number}. Default: \code{"1"}.
\item \bold{boundaries}. Type: \code{number}. Default: \code{"1"}.
\item \bold{loop}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isCompact}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{showShadow}. Type: \code{boolean}. Default: \code{false}.
\item \bold{showControls}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableCursorAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{renderItem}. Type: \code{PaginationItemProps}. Default: \code{NA}.
\item \bold{getItemAriaLabel}. Type: \code{(page: string) => string}. Default: \code{NA}.
\item \bold{classNames}. Type: \code{Partial<Record<'base' OR 'wrapper' OR 'prev' OR 'next' OR 'item' OR 'cursor' OR 'forwardIcon' OR 'ellipsis' OR 'chevronNext', string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onChange}. Type: \code{(page: number) => void}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)
library(thematic)

thematic_shiny()

max <- 10
cards <- lapply(seq_len(max), function(i) {
  tagList(
    spacer(y = 2),
    card(
      id = sprintf("mycard-\%s", i),
      card_header(sprintf("Card \%s", i)),
      card_body(
        sprintf("Card content \%s", i),
        slider_input(
          sprintf("obs-\%s", i),
          "Obs",
          minValue = 0,
          maxValue = 1000,
          value = 500
        ),
        plotOutput(sprintf("distPlot-\%s", i))
      )
    )
  )
})

ui <- nextui_page(
  pagination(
    inputId = "pagination",
    loop = TRUE,
    size = "lg",
    variant = "bordered",
    showControls = TRUE,
    page = 1,
    total = max
  )
)

server <- function(input, output, session) {
  history <- reactiveVal(NULL)

  # Dynamically insert cards with the pagination.
  observeEvent(input$pagination, {
    if (!is.null(history()))
      removeUI(sprintf("#mycard-\%s", history()), multiple = TRUE)
    insertUI(
      selector = "#pagination",
      where = "afterEnd",
      ui = cards[[input$pagination]]
    )
    history(input$pagination)

    output[[sprintf("distPlot-\%s", history())]] <- renderPlot({
      req(input[[sprintf("obs-\%s", history())]])
      hist(
        rnorm(input[[sprintf("obs-\%s", history())]]),
        main = sprintf("Super plot \%s", history())
      )
    })
  })
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/pagination}.
}
