% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qry_insert.R
\name{qry_insert}
\alias{qry_insert}
\title{Insert a row into a table from the shinymgr.sqlite database}
\usage{
qry_insert(tableName, rowValues, shinyMgrPath)
}
\arguments{
\item{tableName}{The name of a table from the shinymgr database to append.}

\item{rowValues}{The values of a row to be inserted into the specified table.
Note: this must be passed as a data frame whose columns match exactly the
table being appended to.}

\item{shinyMgrPath}{File path to the main shiny manager project directory}
}
\value{
integer, number of rows appended
}
\description{
Inserts a record(s) to a specified table in the shinymgr 
database. Used internally as all database tables are populated by shinymgr
functions.
}
\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
Other qry: 
\code{\link{qry_app_flow}()},
\code{\link{qry_app_stitching}()},
\code{\link{qry_mod_info}()},
\code{\link{qry_row}()}
}
\concept{qry}
\keyword{internal}
