% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview-tools.R
\name{preview_app}
\alias{preview_app}
\title{Tools for previewing quizzes}
\usage{
preview_app(quiz, launch_browser = TRUE)
}
\arguments{
\item{quiz}{an object of class 'quiz' to preview}

\item{launch_browser}{launch in a web browser?}
}
\value{
Called for side effect
}
\description{
Launch a viewer to preview the structure of the questions in a quiz.
}
\section{Functions}{
\itemize{
\item \code{preview_app()}: Preview a quiz with full operability

}}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
quiz <- create_quiz(
  create_question(
    'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Select nulla.',
    add_choice('auctor'),
    add_choice('nulla', correct = TRUE)
  ),
  create_question(
    'Mauris congue aliquet dui, ut dapibus lorem porttitor sed. Select 600.',
    add_choice('600', correct = TRUE),
    add_choice('800')
  )
)
preview_app(quiz)
\dontshow{\}) # examplesIf}
}
\author{
Joseph Marlo
}
