% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bench.R
\name{plot.bench}
\alias{plot.bench}
\title{Method for plotting the TIF of the STF}
\usage{
\method{plot}{bench}(
  x,
  fun = "sum",
  theta = seq(-5, 5, length.out = 1000),
  show_both = TRUE,
  ...
)
}
\arguments{
\item{x}{Object of class \code{bench}}

\item{fun}{\code{character}, whether to consider the mean or the sum for the computation of the TIF}

\item{theta}{\code{numeric}, latent trait for the graphical representation}

\item{show_both}{\code{logical}, default is \code{TRUE}. Whether to show or not the TIF obtained from the full-length test}

\item{...}{other arguments}
}
\value{
A \code{ggplot} showing the TIFs of both the STF and the full-length test
}
\description{
The STF is obtained with the benchmark procedure implemented with function \code{bench()}
}
\examples{
set.seed(123)
n <- 50
theta <- rnorm(500, sd = 2)
item_par <- data.frame(
  b = runif(n, -3, 3),
  a = runif(n, 1.2, 1.9),
  c = rep(0, n),
  e = rep(1, n)
)
resB <- bench(item_par, theta = theta, num_item = 5)
plot(resB)
# plot only the TIF of the STF
plot(resB, show_both = FALSE)
}
