% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_proxies.R
\name{read}
\alias{read}
\alias{sg_read_nodes_p}
\alias{sg_read_edges_p}
\alias{sg_read_exec_p}
\title{Read}
\usage{
sg_read_nodes_p(proxy, data, ...)

sg_read_edges_p(proxy, data, ...)

sg_read_exec_p(proxy)
}
\arguments{
\item{proxy}{An object of class \code{sigmajsProxy} as returned by \code{\link{sigmajsProxy}}.}

\item{data}{A \code{data.frame} of _one_ node or edge.}

\item{...}{any column.}
}
\value{
The \code{proxy} object.
}
\description{
Read nodes and edges to add to the graph. Other proxy methods to add data to a graph have to add nodes and edges one by one, 
thereby draining the browser, this method will add multiple nodes and edges more efficiently.
}
\section{Functions}{

\itemize{
  \item{\code{sg_read_nodes_p} read nodes.}
  \item{\code{sg_read_edges_p} read edges.}
  \item{\code{sg_read_exec_p} send read nodes and edges to JavaScript front end.}
}
}

\examples{
library(shiny)

ui <- fluidPage(
	actionButton("add", "add nodes & edges"),
	sigmajsOutput("sg")
)

server <- function(input, output, session){

	nodes <- sg_make_nodes()
	edges <- sg_make_edges(nodes)

	output$sg <- renderSigmajs({
		sigmajs() \%>\% 
			sg_nodes(nodes, id, label, color, size) \%>\% 
			sg_edges(edges, id, source, target) \%>\% 
			sg_layout()
	})

	i <- 10

	observeEvent(input$add, {
		new_nodes <- sg_make_nodes()
		new_nodes$id <- as.character(as.numeric(new_nodes$id) + i)
		i <<- i + 10
		ids <- 1:(i)
		new_edges <- data.frame(
			id = as.character((i * 2 + 15):(i * 2 + 29)),
			source = as.character(sample(ids, 15)),
			target = as.character(sample(ids, 15))
		)
		
		sigmajsProxy("sg") \%>\% 
			sg_force_kill_p() \%>\% 
			sg_read_nodes_p(new_nodes, id, label, color, size) \%>\% 
			sg_read_edges_p(new_edges, id, source, target) \%>\% 
			sg_read_exec_p() \%>\% 
			sg_force_start_p() \%>\% 
			sg_refresh_p()
	})

}

if(interactive()) shinyApp(ui, server)

}
