% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_sig_exposure.R
\name{show_sig_exposure}
\alias{show_sig_exposure}
\title{Plot Signature Exposure}
\usage{
show_sig_exposure(
  Signature,
  sig_names = NULL,
  groups = NULL,
  grp_order = NULL,
  grp_size = NULL,
  samps = NULL,
  cutoff = NULL,
  style = c("default", "cosmic"),
  palette = use_color_style(style),
  base_size = 12,
  font_scale = 1,
  rm_space = FALSE,
  rm_grid_line = TRUE,
  rm_panel_border = FALSE,
  hide_samps = TRUE,
  legend_position = "top"
)
}
\arguments{
\item{Signature}{a \code{Signature} object obtained either from \link{sig_extract} or \link{sig_auto_extract},
or just a raw \strong{absolute} exposure matrix with column representing samples (patients) and row
representing signatures (signature names must end with different digital numbers,
e.g. Sig1, Sig10, x12). If you named signatures with letters,
you can specify them by \code{sig_names} parameter.}

\item{sig_names}{set name of signatures, can be a character vector.}

\item{groups}{sample groups, default is \code{NULL}.}

\item{grp_order}{order of groups, default is \code{NULL}.}

\item{grp_size}{font size of groups.}

\item{samps}{sample vector to filter samples or sort samples, default is \code{NULL}.}

\item{cutoff}{a cutoff value to remove hyper-mutated samples.}

\item{style}{plot style, one of 'default' and 'cosmic', works when
parameter \code{set_gradient_color} is \code{FALSE}.}

\item{palette}{palette used to plot, default use a built-in palette
according to parameter \code{style}.}

\item{base_size}{overall font size.}

\item{font_scale}{a number used to set font scale.}

\item{rm_space}{default is \code{FALSE}. If \code{TRUE}, it will remove border color
and expand the bar width to 1. This is useful when the sample size is big.}

\item{rm_grid_line}{default is \code{FALSE}, if \code{TRUE}, remove grid lines of plot.}

\item{rm_panel_border}{default is \code{TRUE} for style 'cosmic',
remove panel border to keep plot tight.}

\item{hide_samps}{if \code{TRUE}, hide sample names.}

\item{legend_position}{position of legend, default is 'top'.}
}
\value{
a \code{ggplot} object
}
\description{
Currently support copy number signatures and mutational signatures.
}
\examples{
\donttest{
# Load mutational signature
load(system.file("extdata", "toy_mutational_signature.RData",
  package = "sigminer", mustWork = TRUE
))
# Show signature exposure
p1 <- show_sig_exposure(sig2)
p1

# Load copy number signature
load(system.file("extdata", "toy_copynumber_signature_by_W.RData",
  package = "sigminer", mustWork = TRUE
))
# Show signature exposure
p2 <- show_sig_exposure(sig)
p2
}
}
\author{
Shixiang Wang
}
