% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resilp.R
\name{resilp}
\alias{resilp}
\title{resilp}
\usage{
resilp(fit, R = 2000, progress = T, max_try = 100)
}
\arguments{
\item{fit}{A result object from \code{silp}.}

\item{R}{Integer. The number of bootstrap samples. Default is 2000.}

\item{progress}{Logical. Whether to display a progress bar. Default is \code{FALSE}.}

\item{max_try}{Maximum resampling attempts per bootstrap sample.}
}
\value{
An object of class "Silp".
}
\description{
An extended function from \code{silp}, applying the bootstrap method to obtain standard error estimation.
Note: When using \code{silp} with the nearest positive definite matrix (npd = TRUE), this function should be used to obtain
reliable inference.
}
\examples{
n_obs = 100
corr = 0.1
effect = 0.12
ld = c(1,1,1,1)
alp = 0.9
data = generate_data(n_obs, corr, effect, ld, alp)
model = "
  fy =~ y1 + y2 + y3 + y4
  fx =~ x1 + x2 + x3 + x4
  fz =~ z1 + z2 + z3 + z4
  fy ~  fx + fz + fx:fz
"
fit = silp(model, data)
resilp(fit, R = 10)
}
