% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_ReferenceEvapotranspiration.R
\name{cal_ET0_from_PM_for_hourly}
\alias{cal_ET0_from_PM_for_hourly}
\title{Calculating reference evapotranspiration from Penman-Monteith method
   for hourly time step}
\usage{
cal_ET0_from_PM_for_hourly(
  slopVapourPressureCurve,
  netRadiation,
  soilHeatFlux,
  psychrometricConstant,
  meanHourlyTem,
  windSpeed,
  saturationVapourPressure,
  actualVapourPressure
)
}
\arguments{
\item{slopVapourPressureCurve}{saturation slope vapour pressure curve at Thr [kPa &deg;C].}

\item{netRadiation}{net radiation at the grass surface [MJ m-2 hour-1].}

\item{soilHeatFlux}{soil heat flux density [MJ m-2 hour-1].}

\item{psychrometricConstant}{psychrometric constant [kPa &deg;C].}

\item{meanHourlyTem}{mean hourly air temperature [&deg;C].}

\item{windSpeed}{average hourly wind speed [m s-1].}

\item{saturationVapourPressure}{saturation vapour pressure at air temperature Thr [kPa].}

\item{actualVapourPressure}{average hourly actual vapour pressure [kPa].}
}
\value{
A vector for reference evapotranspiration [mm hour-1].
}
\description{
Calculating reference evapotranspiration from Penman-Monteith method
   for hourly time step
}
\details{
In areas where substantial changes in wind speed, dewpoint or
   cloudiness occur during the day, calculation of the ETo equation using
   hourly time steps is generally better than using 24-hour calculation
   time steps. Such weather changes can cause 24-hour means to misrepresent
   evaporative power of the environment during parts of the day and may
   introduce error into the calculations. However, under most conditions,
   application of the FAO Penman-Monteith equation with 24-hour data produces
   accurate results.
}
\note{
With the advent of electronic, automated weather stations, weather
   data are increasingly reported for hourly or shorter periods. Therefore,
   in situations where calculations are computerized, the FAO Penman-Monteith
   equation can be applied on an hourly basis with good results. When applying
   the FAO Penman-Monteith equation on an hourly or shorter time scale, the
   equation and some of the procedures for calculating meteorological data
   should be adjusted for the smaller time step.

 For the calculation of radiation parameters, see P74-75
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
