% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateParams.R
\name{haz}
\alias{haz}
\alias{haz.ExponentialTransition}
\alias{haz.WeibullTransition}
\alias{haz.PWCTransition}
\title{Hazard Function for Different Transition Models}
\usage{
haz(transition, t, trans)

\method{haz}{ExponentialTransition}(transition, t, trans)

\method{haz}{WeibullTransition}(transition, t, trans)

\method{haz}{PWCTransition}(transition, t, trans)
}
\arguments{
\item{transition}{(\code{ExponentialTransition} or \code{WeibullTransition})\cr
see \code{\link[=exponential_transition]{exponential_transition()}} or \code{\link[=weibull_transition]{weibull_transition()}} for details.}

\item{t}{(\code{numeric})\cr time at which hazard is to be computed.}

\item{trans}{(\code{integer})\cr index specifying the transition type.}
}
\value{
The hazard rate for the specified transition and time.
}
\description{
Hazard Function for Different Transition Models
}
\details{
The transition types are:
\itemize{
\item \code{1}: Transition from state 0 (stable) to 1 (progression).
\item \code{2}: Transition from state 0 (stable) to 2 (death).
\item \code{3}: Transition from state 1 (progression) to 2 (death).
}
}
\section{Methods (by class)}{
\itemize{
\item \code{haz(ExponentialTransition)}: for an exponential transition model.

\item \code{haz(WeibullTransition)}: for the Weibull transition model.

\item \code{haz(PWCTransition)}: for the piecewise constant transition model.

}}
\examples{
transition <- exponential_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6)
haz(transition, 0.4, 2)
transition <- exponential_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6)
haz(transition, 0.4, 2)
transition <- weibull_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6, p01 = 2, p02 = 2.5, p12 = 3)
haz(transition, 0.4, 2)
transition <- piecewise_exponential(
  h01 = c(1, 1, 1), h02 = c(1.5, 0.5, 1), h12 = c(1, 1, 1),
  pw01 = c(0, 3, 8), pw02 = c(0, 6, 7), pw12 = c(0, 8, 9)
)
haz(transition, 6, 2)
}
