% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empSignificant.R
\name{passedLogRank}
\alias{passedLogRank}
\title{Helper function to conduct log-rank tests for either PFS or OS}
\usage{
passedLogRank(simTrials, typeEvent, eventNum, critical)
}
\arguments{
\item{simTrials}{(\code{list})\cr simulated trial data sets, see \code{\link[=getClinicalTrials]{getClinicalTrials()}}.}

\item{typeEvent}{(\code{string})\cr endpoint to be evaluated, possible values are \code{PFS} and \code{OS}.}

\item{eventNum}{(\code{integer})\cr number of events required to trigger analysis.}

\item{critical}{(positive \code{number})\cr critical value of the log-rank test.}
}
\value{
Logical vector indicating log-rank test significance for each trial.
}
\description{
This function evaluates the significance of either PFS or OS endpoints for each trial
in a list of trials, based on a pre-specified critical value.
}
\examples{
transition1 <- exponential_transition(h01 = 0.06, h02 = 0.3, h12 = 0.3)
transition2 <- exponential_transition(h01 = 0.1, h02 = 0.4, h12 = 0.3)
simTrials <- getClinicalTrials(
  nRep = 50, nPat = c(800, 800), seed = 1234, datType = "1rowPatient",
  transitionByArm = list(transition1, transition2), dropout = list(rate = 0.5, time = 12),
  accrual = list(param = "intensity", value = 7)
)
passedLogRank(simTrials = simTrials, typeEvent = "PFS", eventNum = 300, critical = 2.4)
}
\keyword{internal}
