% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_do_alleles.R
\name{collapse_do_alleles}
\alias{collapse_do_alleles}
\title{Collapse alleles for simulated DO genotypes}
\usage{
collapse_do_alleles(xodata)
}
\arguments{
\item{xodata}{The sort of detailed genotype/crossover data
generated by \code{\link[=sim_from_pedigree]{sim_from_pedigree()}}.}
}
\value{
The input object, with alleles 9-16 replaced by 1-8.
}
\description{
When simulating Diversity Outbreds, we need to specify parents
1-16, with 9-16 being the males from strains 1-8.  This function
collapses replaces alleles 9-16 with 1-8, to make the result
ordinary DO-type data.
}
\examples{
# simulate DO pedigree
tab <- sim_do_pedigree(8)

# simulate genotypes for that pedigree
dat <- sim_from_pedigree(tab)
# collapse to alleles 1-8
dat <- collapse_do_alleles(dat)

# also works with data on multiple chromosomes
\donttest{dat <- sim_from_pedigree(tab, c("1"=100, "2"=75, "X"=100), xchr="X")
dat <- collapse_do_alleles(dat)}
}
\seealso{
\code{\link[=sim_do_pedigree]{sim_do_pedigree()}}, \code{\link[=sim_do_pedigree_fix_n]{sim_do_pedigree_fix_n()}},
\code{\link[=sim_from_pedigree]{sim_from_pedigree()}}
}
\keyword{utilities}
