% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recomb_map_simplify_chr.R
\name{recomb_map_simplify_chr}
\alias{recomb_map_simplify_chr}
\title{Simplify recombination map of one chromosome to a desired numerical precision}
\usage{
recomb_map_simplify_chr(map, tol = 0.1)
}
\arguments{
\item{map}{A tibble with two columns: \code{pos} position in base pairs, and \code{posg} position in centiMorgans (cM).}

\item{tol}{Tolerance of interpolation errors, in cM.}
}
\value{
The recombination map with rows (positions) removed (if they are interpolated with errors below \code{tol} in most cases).
}
\description{
Given an input recombination map, this function iteratively removes rows that can be interpolated to less than a given error \code{tol}.
This is a heuristic that works very well in practice, resulting in average interpolation errors well below \code{tol}, and maximum final errors no greater than \code{3 * tol} in our internal benchmarks (expected in extremely concave or convex regions of the map; final errors are rarely above \code{tol} with few exceptions).
}
\details{
This function reduces recombination map sizes drastically, in order to include them in packages, and also makes linear interpolation faster.
This simplification operation can be justified as the precision of many existing maps is both limited and overstated, and a high accuracy is not needed for simulations with many other approximations in place.
}
\examples{
library(tibble)
# create a toy recombination map to simplify
# in this case all middle rows can be interpolated from the ends with practically no error
map <- tibble(
    pos  = c(  1L, 1e6L, 2e6L, 3e6L ),
    posg = c( 0.0,  1.0,  2.0,  3.0 )
)

# simplify map!
map_simple <- recomb_map_simplify_chr( map )
# inspect
map_simple

}
\seealso{
\code{\link[=recomb_map_fix_ends_chr]{recomb_map_fix_ends_chr()}} to shift and extrapolate recombination map to ends of chromosome.
}
