% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{pred.plot}
\alias{pred.plot}
\title{Add model fit line (with SE) to GLM models (Poisson, negative binomial etc)}
\usage{
pred.plot(model, xpred = NULL, ci = 0.95)
}
\arguments{
\item{model}{a model object, from (eg) lm glm}

\item{xpred}{the predictor to be plotted on the x axis}

\item{ci}{value for confidence interval (defaults to 0.95)}
}
\value{
ggplot object with fit line
}
\description{
Add model fit line (with SE) to GLM models (Poisson, negative binomial etc)
}
\examples{
#' ## Anwar M, Green JA, Norris P, et al 
## Prospective daily diary study reporting of any and all symptoms in healthy 
## adults in Pakistan: prevalence and #' response
## BMJ Open 2017;7:e014998
\donttest{data(symptom)
glm.symptom <- glm(actual_help_days ~ symp_days_reported, 
     family = "poisson", data = symptom)
pred.plot(glm.symptom)}
}
