% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactionparams.R
\name{interaction_params}
\alias{interaction_params}
\title{Extract simulation parameters for power analysis of regression interaction models.}
\usage{
interaction_params(
  r.x1.y,
  r.x2.y,
  r.x1x2.y,
  r.x1.x2,
  rel.x1 = 1,
  rel.x2 = 1,
  rel.y = 1
)
}
\arguments{
\item{r.x1.y}{Pearson's correlation between x1 and y. Must be between -1 and 1.}

\item{r.x2.y}{Pearson's correlation between x2 and y. Must be between -1 and 1. Assumed to be the 'moderator' in some functions.}

\item{r.x1x2.y}{Pearson's correlation between the interaction term x1x2 (x1 * x2) and y. Must be between -1 and 1.}

\item{r.x1.x2}{Pearson's correlation between x1 and x2. Must be between -1 and 1. Has no default value.}

\item{rel.x1}{Reliability of x1 (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{rel.x2}{Reliability of x2 (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{rel.y}{Reliability of y (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}
}
\value{
A list with the following elements:
  \item{\code{b1}:}{Slope for simulation of x1}
  \item{\code{b2}:}{Slope for simulation of x2}
  \item{\code{b3}:}{Slope for simulation of x1:x2}
  \item{\code{obs.r.x1.x2}:}{Adjusted correlation of x1 and x2}
  \item{\code{obs.r.x1.y}:}{Adjusted correlation of x1 and y}
  \item{\code{obs.r.x2.y}:}{Adjusted correlation of x1 and y}
  \item{\code{obs.r.x1x2.y}:}{Adjusted correlation of x1:x2 and y}
  \item{\code{r2}:}{R-squared}
  \item{\code{sigma}:}{Sigma}
  \item{\code{cov}:}{Adjusted correlation matrix of x1 and x2}
}
\description{
Extract useful simulation parameters for regression.interaction models,
computed via change in R2. This function is largely a wrapper for
\code{\link[InteractionPoweR:power_interaction_r2]{power_interaction_r2()}}
from the \code{InteractionPoweR} package which calculates useful quantities based
on correlations and reliabilities. This function then massages the output into
a more convenient format for simpr as well as calculating R2 and sigma.
}
\examples{
params_all = interaction_params(r.x1.y = -0.18,
 r.x2.y = -0.03,
 r.x1.x2 = 0.64,
 r.x1x2.y = 0.1,
 rel.y = 0.79,
 rel.x1 = 0.89,
 rel.x2 = 0.95)
}
