% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simtimer.R
\name{sim_date}
\alias{sim_date}
\title{Date part of a sim_datetime}
\usage{
sim_date(sim_datetime)
}
\arguments{
\item{sim_datetime}{A sim_datetime (integer representing the passed seconds since origin_date)}
}
\value{
the number of days (24h-intervals) that have passed since origin_date
}
\description{
sim_date() returns the date part of a sim_datetime.
Therefore sim_date() calculates the number of days (24h-intervals) that have
passed since origin_date. If the origin_date of sim_datetime has a time component
different than 00:00:00, the 24h-intervals are correlated to this particular time component.
}
\examples{
sim_date(24*60*60-1)
# [1] 0
sim_date(24*60*60)
# [1] 1
sim_date(452*24*60*60)
# [1] 452
origin_date <- as.POSIXct("2016-01-01 00:00:00", tz = "UTC")
sim_date(as.sim_datetime(as.POSIXct("2016-01-02 00:01:00", tz = "UTC"), origin_date))
# [1] 1
}
