% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sitepickR_diagnostics.R
\name{unitLovePlot}
\alias{unitLovePlot}
\title{Original units balance}
\usage{
unitLovePlot(
  smOut,
  title = "Standardized Mean Difference",
  subtitle = "Initially Selected Units vs. Population"
)
}
\arguments{
\item{smOut}{list; selectMatch() output}

\item{title}{character; user-specified figure title}

\item{subtitle}{character; user-specified figure subtitle}
}
\value{
ggplot object
}
\description{
Balance between initially sampled units and all units in the population
}
\examples{
################################################################################
############## Balance Diagnostics [sitepickR Package] #########################
######### Robert Olsen, Elizabeth A. Stuart & Elena Badillo-Goicoechea (2022) ##
################################################################################

# Basic usage of unitLovePlot()
rawCCD <- sitepickR::rawCCD

uSampVarsCCD <- c("w.pct.frlunch", "w.pct.black", "w.pct.hisp", "w.pct.female") 
suSampVarsCCD <- c("sch.pct.frlunch", "sch.pct.black", "sch.pct.hisp", "sch.pct.female")

dfCCD <- prepDF(rawCCD,
                unitID="LEAID", subunitID="NCESSCH")
dfCCD <- dplyr::filter(dfCCD, unitID \%in\% unique(dfCCD$unitID)[1:80])

smOut <- selectMatch(df = dfCCD, # user dataset
                     unitID = "LEAID", # column name of unit ID in user dataset
                     subunitID = "NCESSCH", # column name of sub-unit ID in user dataset
                     unitVars = uSampVarsCCD, # name of unit level covariate columns
                     subunitSampVars = suSampVarsCCD, # name of sub-unit level covariate columns
                     nUnitSamp = 30,
                     nRepUnits = 5,
                     nsubUnits = 2
)
unitLovePlot(smOut)
}
