% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucket.R
\name{aws_bucket_download}
\alias{aws_bucket_download}
\title{Download an S3 bucket}
\usage{
aws_bucket_download(bucket, dest_path, ...)
}
\arguments{
\item{bucket}{(character) bucket name. required}

\item{dest_path}{(character) destination directory to store files. required}

\item{...}{named parameters passed on to \code{\link[s3fs:download]{s3fs::s3_dir_download()}}}
}
\value{
path (character) to downloaded file(s)/directory
}
\description{
Download an S3 bucket
}
\note{
Requires the env var \code{AWS_REGION}. This function prompts you to make
sure that you want to delete the bucket.
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucket <- random_bucket()
aws_bucket_create(bucket = bucket)
desc_file <- file.path(system.file(), "DESCRIPTION")
aws_file_upload(desc_file, s3_path(bucket, "DESCRIPTION.txt"))
aws_file_upload(desc_file, s3_path(bucket, "d_file.txt"))
temp_dir <- file.path(tempdir(), bucket)
aws_bucket_download(bucket = bucket, dest_path = temp_dir)
fs::dir_ls(temp_dir)

# cleanup
six_bucket_delete(bucket, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other buckets: 
\code{\link{aws_bucket_create}()},
\code{\link{aws_bucket_delete}()},
\code{\link{aws_bucket_exists}()},
\code{\link{aws_bucket_list_objects}()},
\code{\link{aws_bucket_tree}()},
\code{\link{aws_bucket_upload}()},
\code{\link{aws_buckets}()},
\code{\link{six_bucket_delete}()},
\code{\link{six_bucket_upload}()}
}
\concept{buckets}
