% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_plink2_king}
\alias{read_plink2_king}
\title{Read PLINK KING table}
\usage{
read_plink2_king(file)
}
\arguments{
\item{file}{Input file path}
}
\value{
A tibble containing the 6 columns from the \code{plink2 --make-king-table} output.
}
\description{
Reads in the output from \code{plink2 --make-king-table} (\href{https://www.cog-genomics.org/plink/2.0/distance#make_king}{documentation}).
Input \code{file} must have six columns, tab delimited:
\enumerate{
\item id1 (member 1)
\item id2 (member 2)
\item nsnps
\item hethet: proportion of sites where both are heterozygous
\item k: Kinship Coefficient
}
}
\examples{
plink2kingFile <- system.file("extdata", "plink2-king-table.tsv", package="skater", mustWork=TRUE)
plink2king <- read_plink2_king(plink2kingFile)
plink2king
plink2king \%>\% dplyr::filter(k>0.01)

}
\references{
\url{https://www.cog-genomics.org/plink/2.0/distance#make_king}
}
