% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{im_save}
\alias{im_save}
\title{Save an image to disk}
\usage{
im_save(im, name, path, format = "png", quality = 0.95)
}
\arguments{
\item{im}{An image.}

\item{name}{Name of the image file.}

\item{path}{Path to file.}

\item{format}{Image format. Either "jpg", "png", "tiff", or "bmp". Default is "png".}

\item{quality}{(jpg only) default is 0.95. Higher quality means less compression.}
}
\value{
No return value, called for side effects.
}
\description{
Save an image to disk
}
\examples{
\dontrun{
im = sketch(face)

# im.png is saved to the current working directory
im_save( im, name = "im", path = getwd() )

# myimage.jpg is saved to a specified directory
im_save( im, name = "myimage", path = "path/to/image", format = "jpg" )
}
}
