% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cundill.R
\name{n_gamma}
\alias{n_gamma}
\title{Calculate sample size for gamma distribution}
\usage{
n_gamma(
  mean0,
  effect,
  shape0,
  shape1 = shape0,
  alpha = 0.05,
  power = 0.9,
  q = 0.5,
  link = c("log", "identity"),
  two_sided = TRUE
)
}
\arguments{
\item{mean0}{Mean in control group}

\item{effect}{Effect size, \eqn{1 - (\mu_1 / \mu_0)}, where
\eqn{\mu_0} is the mean in the control group (\code{mean0}) and
\eqn{\mu_1} is the mean in the treatment group.}

\item{shape0}{Shape parameter in control group}

\item{shape1}{Shape parameter in treatment group. Defaults to
\code{shape0}, because GLM assumes equal shape across groups.}

\item{alpha}{Type I error rate}

\item{power}{1 - Type II error rate}

\item{q}{Proportion of observations allocated to the control group}

\item{link}{Link function to use. Currently implement: 'log' and 'identity'}

\item{two_sided}{logical, if \code{TRUE} the sample size
will be calculated for a two-sided test. Otherwise, the sample
size will be calculated for a one-sided test.}
}
\value{
Returns an object of class \code{"sample_size"}. It contains
the following components:
\item{N}{the total sample size}
\item{n0}{sample size in Group 0 (control group)}
\item{n1}{sample size in Group 1 (treatment group)}
\item{two_sided}{logical, \code{TRUE}, if the estimated sample size
refers to a two-sided test}
\item{alpha}{type I error rate used in sample size estimation}
\item{power}{target power used in sample size estimation}
\item{effect}{effect size used in sample size estimation}
\item{effect_type}{short description of the type of effect size}
\item{comment}{additional comment, if there is any}
\item{call}{the matched call.}
}
\description{
Estimation of required sample size as given by Cundill & Alexander (2015).
}
\examples{
n_gamma(mean0 = 8.46, effect = 0.7, shape0 = 0.639,
           alpha = 0.05, power = 0.9)
}
\references{
Cundill, B., & Alexander, N. D. E. (2015). Sample size calculations
for skewed distributions. \emph{BMC Medical Research Methodology},
15(1), 1–9. https://doi.org/10.1186/s12874-015-0023-0
}
