% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nifti2Skifti.R
\name{Nifti2Skifti}
\alias{Nifti2Skifti}
\title{Create a SKIFTI file from fsl TBSS skeleton data}
\usage{
Nifti2Skifti(
  Nifti_data = NULL,
  Nifti_skeleton = NULL,
  selected_volumes = NULL,
  Nifti_labels = NULL,
  write_coordinates = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{Nifti_data}{Intensity data in Nifti format (required)}

\item{Nifti_skeleton}{Skeleton at same imaging space as the data, in Nifti format (required)}

\item{selected_volumes}{Selected volume indexes starting from 1 (default==NULL, selecting all)}

\item{Nifti_labels}{Labeling data to be used inside mask, writing extra line to the output about labels (default==NULL, no extra labeling)}

\item{write_coordinates}{TRUE/FALSE(default) write coordinates of voxels in x,y,z ASCII format, in the same order as they appear in the skifti}

\item{verbose}{TRUE/FALSE(default) for verbose messages}
}
\value{
skifti object with default rownames as vol1, vol2 .... volN as indexes from the nifti data
}
\description{
Skeleton mask and corresponding image intensity data must be in Nifti format.
The skeleton mask is used to determine the coordinates of intensity data.
If optional label file is given, that is used to label the voxels.
}
\examples{
#source('../../R/Skifti2Nifti.R')
#source('../../R/Nifti2Skifti.R')
library(RNifti)
data<-array(0,dim=list(10,10,10,10))
for(t in 1:10) {
  for(x in 1:10) {
    for(y in 1:10) {
      for(z in 1:10) {
        data[x,y,z,t]<-t+x
      }
    }
  }
}
data_Nifti<-RNifti::retrieveNifti(data)
RNifti::writeNifti(data_Nifti, "data_Nifti.nii.gz", template = NULL, datatype = "auto")

data_skeleton<-array(0,dim=list(10,10,10))
data_skeleton[5,5,5]<-1
data_skeleton[6,6,6]<-1
data_skeleton[7,7,7]<-1
data_skeleton_Nifti<-RNifti::retrieveNifti(data_skeleton)
RNifti::writeNifti(data_skeleton_Nifti, "data_skeleton_Nifti.nii.gz", datatype = "auto")

data_Skifti<-Nifti2Skifti(Nifti_data="data_Nifti.nii.gz", 
                          Nifti_skeleton="data_skeleton_Nifti.nii.gz", 
                          selected_volumes=c(1), 
                          Nifti_labels=NULL, 
                          write_coordinates=TRUE, 
                          verbose=FALSE)

# Create Skifti
data_Nifti2<-Skifti2Nifti(data_Skifti)
RNifti::writeNifti(data_Nifti2[[1]], "data_Nifti.nii.gz", datatype = "auto")
data_Nifti2<-RNifti::readNifti("data_Nifti.nii.gz", internal = TRUE, volumes = NULL)
}
